// DirectDraw Three Output Screen (dtos) code
#include "app.h"
#include "dto.h"

int nDtosWidth=0,nDtosHeight=0; // screen size
int nDtosDepth=0,nDtosBpp=0;
static int bDtosScan=0;
unsigned char *DtosMem=NULL; // Memory buffer
int nDtosMemPitch=0; // Memory buffer pitch
static int nHalfMask=0;
extern int DirectScreen();
extern "C" int dprintf(char *format, ...);

// Create a buffer in normal memory
static int DtosMakeMem()
{
  int nMemLen=0;
  nDtosMemPitch=nDtosWidth*nDtosBpp;
  nMemLen=nDtosHeight*nDtosMemPitch;
  DtosMem=(unsigned char *)malloc(nMemLen);
  if (DtosMem==NULL) { dprintf("DtosMem==NULL\n"); return 1; }
  memset(DtosMem,0,nMemLen);
  return 0;
}

int DtosInit()
{
  dprintf("DtosInit Start\n");
  int nRet=0;
  if (bDrvOkay==0) { dprintf("bDrvOkay==0\n"); return 1; }
  bDtosScan=bVidScanlines?1:0;

  // Get the game screen size
  BurnDrvGetScreen(&nDtosWidth,&nDtosHeight);

  nDtosDepth=16;//GetSurfaceDepth(DtoPrim); // Get color depth of primary surface
  nDtosBpp=(nDtosDepth+7)>>3;
  nBurnBpp=nDtosBpp; // Set Burn library Bytes per pixel
  // Make the mask to mask out all but the lowest intensity bit
  nHalfMask=0;
       if (nDtosDepth==15) nHalfMask=0xfbdefbde;
  else if (nDtosDepth==16) nHalfMask=0xf7def7de;
  else nHalfMask=0xfefefefe;

  // Use our callback to get colors:
  SetBurnHighCol(nDtosDepth);
  // Recalculate the whole palette next time BurnDraw is called
  // This will use our callback for the whole palette
  BurnRecalcPal();

  // Make the normal memory buffer
  nRet=DtosMakeMem(); if (nRet!=0) { dprintf("nRet!=0\n"); DtosExit(); return 1; }

  dprintf("DtosInit End\n");
  return 0;
}

int DtosExit()
{
  if (DtosMem!=NULL) free(DtosMem);  DtosMem=NULL;
  nBurnBpp=0; // Blank the Burn library Bytes per pixel
  bDtosScan=0;
  return 0;
}

// Run one frame and render the screen
int DtosFrame()
{
	if (DtosMem==NULL) return 1;

  pBurnDraw=DtosMem; nBurnPitch=nDtosMemPitch;

  if (bDrvOkay)
  {
    dprintf("RunFrame\n");
    BurnDrvFrame(); // Run one frame and draw the screen
  }
  else
  {
    // Blank the screen
    memset(DtosMem,0,nDtosMemPitch*nDtosHeight);
  }
  pBurnDraw=NULL; nBurnPitch=0;

  DirectScreen();
  return 0;
}

// Paint the Dtos surface onto the primary surface
int DtosPaint(int bValidate)
{
  return 0;
}

